/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.ResourceInstance;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.EventListener;
import ibm.nways.analysis.dpManager.RegistryEvent;
import ibm.nways.analysis.dpManager.dpServerImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class EventRegistry {
    public static final int MAX_EVENTS_STORED = 500;
    public static final long MAX_FILE_LENGTH = 1000000L;
    public static final int FLUSHSIZE = 100;
    public static final String writeFile = "eventlog.txt";
    public static boolean writeToDisk;
    private Vector eventVector = new Vector();
    private dpServerImpl refServer;
    private BufferedWriter writeBuffer;
    private File pseudoFile;
    private Vector eventListeners = new Vector();

    public EventRegistry(dpServerImpl dpServerImpl2) {
        try {
            this.refServer = dpServerImpl2;
            if (writeToDisk) {
                this.writeBuffer = new BufferedWriter(new FileWriter(writeFile));
                this.pseudoFile = new File(writeFile);
                return;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("EventRegistry: an exception occurred:", exception);
        }
    }

    public void addListener(AppletNotifyInterface appletNotifyInterface, EventFilter eventFilter) {
        EventListener eventListener = null;
        eventListener = eventFilter != null ? new EventListener(this, appletNotifyInterface, eventFilter) : new EventListener(this, appletNotifyInterface);
        this.eventListeners.addElement(eventListener);
    }

    public void addListener(AppletNotifyInterface appletNotifyInterface) {
        this.addListener(appletNotifyInterface, null);
    }

    public void removeListener(AppletNotifyInterface appletNotifyInterface) {
        if (this.eventListeners != null) {
            Enumeration enumeration = this.eventListeners.elements();
            while (enumeration.hasMoreElements()) {
                EventListener eventListener = (EventListener)enumeration.nextElement();
                if (!eventListener.getAppletObject().equals(appletNotifyInterface)) continue;
                this.eventListeners.removeElement(eventListener);
                eventListener.stop();
                return;
            }
        }
    }

    public void removeAllListeners() {
        if (this.eventListeners != null) {
            Enumeration enumeration = this.eventListeners.elements();
            while (enumeration.hasMoreElements()) {
                EventListener eventListener = (EventListener)enumeration.nextElement();
                this.eventListeners.removeElement(eventListener);
                eventListener.stop();
            }
        }
    }

    public synchronized long getCurrentEventDate() {
        long l = System.currentTimeMillis();
        if (this.eventVector != null && this.eventVector.size() > 1) {
            l = ((RegistryEvent)this.eventVector.lastElement()).getTimeReceived();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processStatus(PerformanceEvent performanceEvent) {
        try {
            Vector vector = this.refServer.getResourceInstances(performanceEvent);
            Enumeration enumeration = vector.elements();
            while (enumeration != null) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                ResourceInstance resourceInstance = (ResourceInstance)enumeration.nextElement();
                PerformanceEvent performanceEvent2 = null;
                if (resourceInstance != null && performanceEvent.getCause() == 1) {
                    performanceEvent2 = resourceInstance.incArmed(performanceEvent);
                }
                if (performanceEvent2 == null) continue;
                this.insertEvent(performanceEvent2);
            }
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("EventRegistry:Exception occurred", exception);
        }
    }

    private void insertOneEvent(Object object) {
        if (object instanceof PerformanceEvent) {
            PerformanceEvent performanceEvent = (PerformanceEvent)object;
            if (this.eventVector.size() >= 500) {
                this.flushEvents();
            }
            long l = System.currentTimeMillis();
            this.eventVector.addElement(new RegistryEvent(performanceEvent, l));
            if (performanceEvent.getEventType() != 32 && (performanceEvent.getCause() == 1 || performanceEvent.getCause() == 2)) {
                this.processStatus(performanceEvent);
            }
        }
    }

    public synchronized void insertEvent(PerformanceEvent performanceEvent) {
        this.insertOneEvent(performanceEvent);
        this.notifyAll();
    }

    public synchronized void insertEvent(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.insertOneEvent(vector.elementAt(n));
            ++n;
        }
        this.notifyAll();
    }

    protected void finalize() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.close();
        }
    }

    public synchronized void flushEvents() {
        try {
            int n = 0;
            while (n < 100) {
                if (writeToDisk) {
                    if (this.pseudoFile.length() > 1000000L) {
                        this.writeBuffer.close();
                        File file = new File("eventlog.txt.bak");
                        dpServerImpl.DM("deleting old backup file : eventlog.txt.bak");
                        file.delete();
                        this.pseudoFile.renameTo(file);
                        this.writeBuffer = new BufferedWriter(new FileWriter(writeFile));
                        this.pseudoFile = new File(writeFile);
                    }
                    if (((RegistryEvent)this.eventVector.elementAt(0)).getPerformanceEvent().getCause() != 4) {
                        this.writeBuffer.write(((RegistryEvent)this.eventVector.elementAt(0)).getPerformanceEvent().toLineString());
                        this.writeBuffer.flush();
                    }
                }
                this.eventVector.removeElementAt(0);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("EventRegistry: an exception occurred:", exception);
            return;
        }
    }

    public void clearEvents(Vector vector) {
        PerformanceEvent performanceEvent = null;
        Vector vector2 = this.eventVector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Serializable serializable;
                Object object;
                PerformanceEvent performanceEvent2 = (PerformanceEvent)enumeration.nextElement();
                if (this.refServer.getDBC() == null) {
                    object = new RegistryEvent(performanceEvent2, 0L);
                    int n = this.eventVector.indexOf(object);
                    if (n > -1) {
                        serializable = ((RegistryEvent)this.eventVector.elementAt(n)).getPerformanceEvent();
                        ((PerformanceEvent)serializable).clear();
                    }
                } else if (this.refServer.getDBC() != null && this.refServer.getDBC().isCollecting()) {
                    this.refServer.getDBC().clearEvent(performanceEvent2);
                }
                object = this.refServer.getResourceInstances(performanceEvent2);
                Enumeration enumeration2 = ((Vector)object).elements();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    serializable = (ResourceInstance)enumeration2.nextElement();
                    if (serializable == null || performanceEvent2.getCause() != 1) continue;
                    int n = performanceEvent2.getCause();
                    performanceEvent2.clear();
                    performanceEvent = ((ResourceInstance)serializable).decArmed(performanceEvent2);
                    performanceEvent2.setCause(n);
                }
            }
        }
        if (performanceEvent != null) {
            this.insertEvent(performanceEvent);
        }
    }

    public Vector getEvents() {
        return this.getEvents(null);
    }

    public Vector getEvents(EventFilter eventFilter) {
        Vector vector = null;
        if (this.refServer.getDBC() != null && this.refServer.getDBC().isCollecting()) {
            vector = this.refServer.getDBC().getEvents(eventFilter);
            if (vector != null) {
                dpServerImpl.DM("The database returned: " + vector.size() + " events");
            }
        } else {
            vector = new Vector();
            Vector vector2 = this.eventVector;
            synchronized (vector2) {
                Enumeration enumeration = this.eventVector.elements();
                while (enumeration.hasMoreElements()) {
                    RegistryEvent registryEvent = (RegistryEvent)enumeration.nextElement();
                    if (eventFilter != null && eventFilter.filter(registryEvent.getPerformanceEvent(), this.refServer)) {
                        vector.addElement(registryEvent.getPerformanceEvent());
                        continue;
                    }
                    if (eventFilter != null) continue;
                    vector.addElement(registryEvent.getPerformanceEvent());
                }
            }
        }
        if (vector != null && vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    public synchronized Vector getEvent(long l) {
        while (this.eventVector.size() < 1 || this.getCurrentEventDate() <= l) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                dpServerImpl.DM("EventRegistry: an exception occurred:", exception);
            }
        }
        int n = this.eventVector.size() - 1;
        Vector<RegistryEvent> vector = new Vector<RegistryEvent>();
        while (n >= 0 && ((RegistryEvent)this.eventVector.elementAt(n)).getTimeReceived() > l) {
            vector.insertElementAt((RegistryEvent)this.eventVector.elementAt(n), 0);
            --n;
        }
        return vector;
    }

    public dpServerImpl getServer() {
        return this.refServer;
    }
}

